/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.transition.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import dev.tr7zw.transition.config.ConfigUpgrader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigManager<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private T config;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final File configFile;
    private final Supplier<T> instanceProvider;
    private final ConfigUpgrader configUpgrader;

    public ConfigManager(String name, Supplier<T> instanceProvider, ConfigUpgrader<T> configUpgrader) {
        this.instanceProvider = instanceProvider;
        this.configUpgrader = configUpgrader;
        this.configFile = new File("config", name + ".json");
        if (this.configFile.exists()) {
            try {
                this.config = this.gson.fromJson(Files.readString(this.configFile.toPath()), instanceProvider.get().getClass());
            }
            catch (JsonSyntaxException | IOException exception) {
                LOGGER.warn("Error while loading config: {}", (Object)exception.getMessage());
                LOGGER.warn("A new configuration will be created!");
            }
        }
        if (this.config == null) {
            this.reset();
        } else if (configUpgrader != null && configUpgrader.upgradeConfig(this.config)) {
            this.writeConfig();
        }
    }

    public T getConfig() {
        return this.config;
    }

    public void reset() {
        this.config = this.instanceProvider.get();
        this.writeConfig();
    }

    public void writeConfig() {
        if (this.configFile.exists() && !this.configFile.delete()) {
            LOGGER.warn("Config {} could not be deleted before writing to it!", (Object)this.configFile.getName());
        }
        try {
            Files.writeString(this.configFile.toPath(), (CharSequence)this.gson.toJson(this.config), new OpenOption[0]);
        }
        catch (IOException ioException) {
            LOGGER.warn("Error when writing config file {}!", (Object)this.configFile.getName(), (Object)ioException);
        }
    }
}

